/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class Startup
extends MIDlet
implements CommandListener {
    short[][] crateLevels = new short[16][771];
    private GameScreen canvas;
    private TitleScreen title;
    int prevLevel;
    Command exitCommand = new Command("Quit", 7, 0);
    Command resumeGame = new Command("Resume", 8, 0);
    Command newGame = new Command("New Game", 8, 1);
    Command aboutGame = new Command("About", 8, 1);
    Command returnMain = new Command("Quit", 2, 0);
    Command resetLevel = new Command("Reset Level", 8, 0);
    Command selectLevel = new Command("Select Level", 8, 0);
    Command toggleSize = new Command("Block Size", 8, 0);
    Command helpKeys = new Command("Help", 8, 1);
    boolean useLarge = true;
    Form levelSelect = new Form("Level");
    String[] LevelCaptions = new String[]{"Training 1", "Training 2", "Training 3", "Easy 4", "Easy 5", "Easy 6", "Easy 7", "Medium 8", "Medium 9", "Medium 10", "Medium 11", "Hard 12", "Hard 13", "Hard 14", "Hard 15", "Hard 16"};
    ChoiceGroup lvlGroup = new ChoiceGroup("Level Number", 1, this.LevelCaptions, null);
    Command chooseNewLevel = new Command("Return to Game", 1, 0);
    int levelNumber = 0;

    public Startup() {
        for (int i = 1; i <= 16; ++i) {
            try {
                int n;
                InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/levels/level" + i + ".c3d");
                int n2 = 0;
                for (int j = 0; j <= 3; ++j) {
                    inputStream.read();
                }
                while ((n = inputStream.read()) != -1) {
                    this.crateLevels[i - 1][n2] = (short)n;
                    ++n2;
                }
                inputStream.close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.title = new TitleScreen();
        this.title.addCommand(this.exitCommand);
        this.title.addCommand(this.newGame);
        this.title.addCommand(this.aboutGame);
        this.title.addCommand(this.helpKeys);
        this.title.setCommandListener(this);
        this.levelSelect.append((Item)this.lvlGroup);
        this.levelSelect.addCommand(this.chooseNewLevel);
        this.levelSelect.setCommandListener((CommandListener)this);
        this.canvas = new GameScreen();
        this.canvas.addCommand(this.returnMain);
        this.canvas.addCommand(this.resetLevel);
        this.canvas.addCommand(this.selectLevel);
        this.canvas.addCommand(this.toggleSize);
        this.canvas.setCommandListener(this);
        Display display = Display.getDisplay((MIDlet)this);
        display.setCurrent((Displayable)this.title);
    }

    public void commandAction(Command command, Displayable displayable) {
        Display display = Display.getDisplay((MIDlet)this);
        if (command == this.newGame) {
            this.levelNumber = 0;
            GameScreen.unpackLevel(this.crateLevels[this.levelNumber]);
            display.setCurrent((Displayable)this.canvas);
        } else if (command == this.resumeGame) {
            display.setCurrent((Displayable)this.canvas);
        } else if (command == this.exitCommand) {
            this.destroyApp(true);
            this.notifyDestroyed();
        } else if (command == this.aboutGame) {
            Alert alert = new Alert("About", "Crates3D\nBen Ryves 2004\nBased on the game by Badja\nGreenfire Productions", null, AlertType.INFO);
            display.setCurrent((Displayable)alert);
        } else if (command == this.returnMain) {
            if (displayable == this.canvas) {
                this.title.addCommand(this.resumeGame);
            }
            display.setCurrent((Displayable)this.title);
        } else if (command == this.selectLevel) {
            this.prevLevel = this.levelNumber;
            display.setCurrent((Displayable)this.levelSelect);
        } else if (command == this.chooseNewLevel) {
            this.lvlGroup.getSelectedIndex();
            this.levelNumber = this.lvlGroup.getSelectedIndex();
            if (this.levelNumber != this.prevLevel) {
                GameScreen.unpackLevel(this.crateLevels[this.levelNumber]);
            }
            display.setCurrent((Displayable)this.canvas);
        } else if (command == this.toggleSize) {
            this.useLarge = !this.useLarge;
            GameScreen.loadImages(this.useLarge);
            this.canvas.repaint();
        } else if (command == this.resetLevel) {
            GameScreen.unpackLevel(this.crateLevels[this.levelNumber]);
            this.canvas.repaint();
        } else if (command == List.SELECT_COMMAND) {
            Alert alert = new Alert("Well Done", "Well Done!\nYou have completed the level!", null, AlertType.INFO);
            display.setCurrent((Displayable)alert);
            ++this.levelNumber;
            this.levelNumber &= 0xF;
            GameScreen.unpackLevel(this.crateLevels[this.levelNumber]);
            display.setCurrent((Displayable)this.canvas);
        } else if (command == this.helpKeys) {
            Form form = new Form("Help");
            form.append("The aim of the game is to try and get your crate from one end of the course to sit on top of the crate at the other end.\nYou can move around with the up, down, left and right keys. You can only move up and down one crate at a time.\nBy holding the fire key and moving towards another crate you can push crates around the level. Crates will only move if they are on top of something else. Use the a and b keys to rotate the view.\nOn a cellphone, the movement keys are usually 2,4,6 and 8 and the a and b keys are either 1 and 3 or 7 and 9. Fire is typically 5. Just have a look around and see what the keys do!");
            form.addCommand(this.returnMain);
            form.setCommandListener((CommandListener)this);
            display.setCurrent((Displayable)form);
        }
    }

    protected void destroyApp(boolean bl) {
    }

    protected void pauseApp() {
    }

    protected void startApp() {
    }
}

