/* -------------------------------------------------
 * CRATES 3D
 * -------------------------------------------------
 * A J2ME game for MIDP1 Devices.
 * (c) Benjamin Ryves 2004 for Greenfire Productions
 * Based on an original game by Badga.
 * -------------------------------------------------
 */

/* ADDED DETAILS: 2005 RELEASE
 * e: benryves@benryves.com
 * w: www.benryves.com
 * You use this source at your own risk!
 * If you use any of it in your own projects, give credit where it's due...
 * but I can't enforce that, and frankly I don't care.
 */


import java.io.*;
import javax.microedition.lcdui.*;
import javax.microedition.midlet.*;
import java.util.*;

class GameScreen extends Canvas {

	static Image[] crate;
	static Image[] mover;


	int scrWidth;
	int scrHeight;
	int scrXCentre;
	int scrYCentre;

	static int blockX;
	static int blockY;
	static int blockZ;

	static int endX;
	static int endY;
	static int endZ;
	
	private CommandListener listener;

	static boolean useLargeImages;

	boolean heldPush = false;

	int viewAngle = 0;

	static int[][][] crateWorld;


	Form gameForm;

	public GameScreen() {
		scrWidth = this.getWidth();
		scrHeight = this.getHeight();
		scrXCentre = scrWidth/2;
		scrYCentre = scrHeight/2;
		loadImages(true);

	}

    public void setCommandListener(CommandListener l) {
		super.setCommandListener(l);
        listener = l;
    }

	static void loadImages(boolean large) {
		useLargeImages = large;
		String s;
		if (large) {
			s = "b";
		} else {
			s = "s";
		}

		try {
			crate = new Image[4];
			mover = new Image[4];
			for (int i=0;i<4;i++) {
				crate[i] = Image.createImage("/images/crate"+i+s+".png");
				mover[i] = Image.createImage("/images/mover"+i+s+".png");
			}

		} catch (java.io.IOException ex) { }

	}

	protected void keyPressed(int keyCode) {
		crateWorld[blockX][blockY][blockZ] = 0;

		int keyAction = getGameAction(keyCode);
		int blockXTest = 0;
		int blockYTest = 0;

		if (keyAction == Canvas.RIGHT) {
			blockYTest=1;
		} else if (keyAction == Canvas.LEFT) {
			blockYTest=-1;
		} else if (keyAction == Canvas.UP) {
			blockXTest=1;
		} else if (keyAction == Canvas.DOWN) {
			blockXTest=-1;
		} else if (keyAction == Canvas.GAME_A) {
			rotateLevel(true);
		} else if (keyAction == Canvas.GAME_B) {
			rotateLevel(false);
		} else if (keyAction == Canvas.FIRE) {
			heldPush = true;
		}


		if (heldPush && blockExists(blockX+blockXTest,blockY+blockYTest,blockZ)) {
			int moveStatus = canBeMoved(blockX+blockXTest,blockY+blockYTest,blockZ,blockXTest,blockYTest,true);
			if ((moveStatus&1)!=0) {
				int moveX;
				int moveY;
				int moveZ;
				moveX = blockX+2*blockXTest;
				moveY = blockY+2*blockYTest;
				moveZ = blockZ;

				if ((moveStatus&2)!=0) {
					moveZ++;
				}
				if ((moveStatus&4)!=0) {
					moveZ--;
				}

				crateWorld[moveX][moveY][moveZ]=1;
				crateWorld[blockX+blockXTest][blockY+blockYTest][blockZ]=0;

				// Make crate drift away downwards
				if (moveZ>0 && crateWorld[moveX][moveY][moveZ-1]==0) {
					do {
						crateWorld[moveX][moveY][moveZ]=0;
						moveZ--;
						crateWorld[moveX][moveY][moveZ]=1;
						repaint();
						if (moveZ==0) {
							crateWorld[moveX][moveY][moveZ]=0;	// Destroy block that has fallen off the world
							break;
						}
					} while (moveZ>0 && crateWorld[moveX][moveY][moveZ-1]==0);
				}
			}
		}

		int moveStatus = canBeMoved(blockX,blockY,blockZ,blockXTest,blockYTest,false);

		if ((moveStatus&1)!=0) {
			blockX+=blockXTest;
			blockY+=blockYTest;
			if ((moveStatus&2)!=0) {
				blockZ++;
			}
			if ((moveStatus&4)!=0) {
				blockZ--;
			}
		}

		crateWorld[blockX][blockY][blockZ] = 2;

		if (blockX==endX && blockY==endY && blockZ==(endZ+1)) {
			serviceRepaints();
			listener.commandAction(List.SELECT_COMMAND, this);
		}
		
		repaint();
		

	}


	protected void keyReleased(int keyCode) {
		int keyAction = getGameAction(keyCode);
		if (keyAction == Canvas.FIRE) {
			heldPush = false;
		}
	}

	private boolean blockExists(int x,int y,int z) {
		if (x>=0 && x<=31 && y>=0 && y<=31 && z>=0 && z<=8) {
			if (crateWorld[x][y][z]!=0) {
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	void rotateLevel(boolean anticlockwise) {
		int[][] rotateLevel;
		rotateLevel = new int[32][32];
		for (int z=0;z<8;z++) {
			for (int x=0;x<32;x++) { for (int y=0;y<32;y++) {
				rotateLevel[x][y]=crateWorld[x][y][z];
		
			}}
			for (int x=0;x<32;x++) { for (int y=0;y<32;y++) {
				if (anticlockwise) {
					crateWorld[x][y][z]=rotateLevel[31-y][x];
				} else {
					crateWorld[x][y][z]=rotateLevel[y][31-x];
				}
			}}
		}
		if (anticlockwise) {
			int tempY = blockY;
			blockY = 31-blockX;
			blockX = tempY;
			tempY = endY;
			endY = 31-endX;
			endX = tempY;
			viewAngle++;
		} else {
			int tempX = blockX;
			blockX = 31-blockY;
			blockY = tempX;
			tempX = endX;
			endX = 31-endY;
			endY = tempX;
			viewAngle--;
		}
		
		viewAngle = viewAngle & 0x3;

	}
	

	protected int canBeMoved(int oldX, int oldY, int oldZ, int dX, int dY, boolean isMover) {
		int oldXTest = oldX+dX;
		int oldYTest = oldY+dY;
		int oldZTest = oldZ;
		int canMove = 0;
		int shiftZ = 0;

		if (oldXTest>=0 && oldXTest<=31 && oldYTest>=0 && oldYTest<=31 && oldZTest>=0 && oldZTest<=8) {
			if (crateWorld[oldXTest][oldYTest][oldZTest]==0) {
				if (oldZTest>0) {
					if (crateWorld[oldXTest][oldYTest][oldZTest-1]!=0 || isMover) {
						canMove=1;
					} else {
						if (oldZTest>1) {
							if (crateWorld[oldXTest][oldYTest][oldZTest-2]!=0) {
								canMove = 1;
								shiftZ = 4;
							}
						}
					}
				} else {
					canMove=1;
				}
			} else if (crateWorld[oldXTest][oldYTest][oldZTest+1]==0 && !isMover) {
				canMove = 1;
				shiftZ = 2;
			}

		}

		if (isMover && crateWorld[oldX][oldY][oldZ-1]==0) {
			canMove = 0;
		}

		return canMove+shiftZ;

	}


	protected void paint(Graphics g) {
		g.setColor(0);
		g.fillRect(0,0,scrWidth,scrHeight);
		for (int z=0; z<=8; z++) {
			for (int x=31; x>=0; x--) {
				for (int y=31; y>=0; y--) {
					

					if (crateWorld[x][y][z]!=0) {

						int oX = blockX - x;
						int oY = blockY - y;
						int oZ = blockZ - z;
						int realX, realY;

						if (useLargeImages) {
							realX = -oY*6 + oX*6 + scrXCentre;
							realY = oX*3 + oY*3 + oZ*7 + scrYCentre;
						} else {
							realX = -oY*4 + oX*4 + scrXCentre;
							realY = oX*2 + oY*2 + oZ*4 + scrYCentre;
						}
					
						if (realX>-6 && realX<scrWidth+6 && realY>-6 && realY<scrHeight+6) {


						if (crateWorld[x][y][z]==1) {
							g.drawImage(crate[viewAngle], realX, realY, Graphics.VCENTER | Graphics.HCENTER);
						} else if (crateWorld[x][y][z]==2) {
							g.drawImage(mover[viewAngle], realX, realY, Graphics.VCENTER | Graphics.HCENTER);
						}
						
						}

						
					}
				}
			}
		}
	}

	static void unpackLevel(short[] levelToUnpack) {
		int[] bitMasks = {1,2,4,8,16,32,64,128};

		int currentLevelBlock = 0;
		int levelUnpackPointer = 6;

		crateWorld = new int[32][32][9];

		blockX = 23-(int)levelToUnpack[1];
		blockY = (int)levelToUnpack[0];
		blockZ = (int)levelToUnpack[2];
		endX = 23-(int)levelToUnpack[4];
		endY = (int)levelToUnpack[3];
		endZ = (int)levelToUnpack[5];
		
		int wxp = 0;
		int wyp = 0;
		int wzp = 0;

		int[] uncompressed = new int[768];
	
		int cp = 0;

		int p = 0;
		int i = 6;
		int rB = 0;

		do {
			rB = (levelToUnpack[i]);

   			if (rB==0x91) {
        
    			i++;	
				short b = levelToUnpack[i];
    			i++;
    			short l = levelToUnpack[i];
        		for (short j=1; j<=l; j++) {
					uncompressed[p] = b;
					p++;
				}

        			i++;
			} else {
				uncompressed[p] = rB;
				p++;
				i++;
			}
    
		} while (p <= 767);

		int o = 0;
		for (int x=23; x>=0; x--) {
			for (int y=0; y<=31; y++) {
				for (int z=0; z<=7; z++) {
					int checkFactor = bitMasks[z];
					int levelFactor = uncompressed[o];

					
					if ((checkFactor&levelFactor)!=0) {
						crateWorld[x][y][z] = 1;
					} else {
						crateWorld[x][y][z] = 0;
					}
                		}
	                	o++;
			}
        	}
        
		crateWorld[blockX][blockY][blockZ] = 2;
		crateWorld[endX][endY][endZ] = 2;
	}

}