/* -------------------------------------------------
 * CRATES 3D
 * -------------------------------------------------
 * A J2ME game for MIDP1 Devices.
 * (c) Benjamin Ryves 2004 for Greenfire Productions
 * Based on an original game by Badga.
 * -------------------------------------------------
 */

/* ADDED DETAILS: 2005 RELEASE
 * e: benryves@benryves.com
 * w: www.benryves.com
 * You use this source at your own risk!
 * If you use any of it in your own projects, give credit where it's due...
 * but I can't enforce that, and frankly I don't care.
 */


import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;
import java.io.*;


public class Startup extends MIDlet implements CommandListener {



	short[][] crateLevels = new short[16][771];

	private GameScreen canvas;
	private TitleScreen title;
	
	int prevLevel;
	
	Command exitCommand = new Command("Quit", Command.EXIT, 0 );
	Command resumeGame = new Command("Resume",Command.ITEM,0);
	Command newGame = new Command("New Game",Command.ITEM,1);
	Command aboutGame = new Command("About",Command.ITEM,1);

	Command returnMain = new Command("Quit",Command.BACK,0);

	Command resetLevel = new Command("Reset Level",Command.ITEM,0);
	Command selectLevel = new Command("Select Level",Command.ITEM,0);

	Command toggleSize = new Command("Block Size",Command.ITEM,0);

	Command helpKeys = new Command("Help",Command.ITEM,1);

	boolean useLarge = true;	


	Form levelSelect = new Form("Level");
	String LevelCaptions[] = new String[]
		{
			"Training 1",
			"Training 2",
			"Training 3",
			"Easy 4",
			"Easy 5",
			"Easy 6",
			"Easy 7",
			"Medium 8",
			"Medium 9",
			"Medium 10",
			"Medium 11",
			"Hard 12",
			"Hard 13",
			"Hard 14",
			"Hard 15",
			"Hard 16"
		};
	ChoiceGroup lvlGroup = new ChoiceGroup("Level Number",ChoiceGroup.EXCLUSIVE, LevelCaptions, null);
	Command chooseNewLevel = new Command("Return to Game",Command.SCREEN,0);


	int levelNumber = 0;

	public Startup() {


		int streamPosition;
		for (int l=1; l<=16; l++) {
			try {
				InputStream levelData = getClass().getResourceAsStream("/levels/level"+l+".c3d");
				int readByte;
				streamPosition = 0;
				for (int i=0;i<=3;i++) {
					levelData.read();
				}
				while ((readByte=levelData.read())!=-1) {
					crateLevels[l-1][streamPosition]=(short)readByte;
					streamPosition++;
				}
				levelData.close();

	
			} 
			catch (IOException ex) { }
		}

		title = new TitleScreen();
		title.addCommand(exitCommand);
		title.addCommand(newGame);
		title.addCommand(aboutGame);
		title.addCommand(helpKeys);
		title.setCommandListener(this);
		
		levelSelect.append(lvlGroup);
		levelSelect.addCommand(chooseNewLevel);
		levelSelect.setCommandListener(this);

		canvas = new GameScreen();
		canvas.addCommand(returnMain);
		canvas.addCommand(resetLevel);
		canvas.addCommand(selectLevel);
		canvas.addCommand(toggleSize);
		canvas.setCommandListener(this);

		Display display = Display.getDisplay(this);
		display.setCurrent(title);

	}
	


	public void commandAction(Command c, Displayable d) {
		Display display = Display.getDisplay(this);

		if (c==newGame) {
			levelNumber = 0;
			GameScreen.unpackLevel(crateLevels[levelNumber]);
			display.setCurrent(canvas);
		} else if (c==resumeGame) {
			display.setCurrent(canvas);
		} else if (c==exitCommand) {
			destroyApp(true);
			notifyDestroyed();
		} else if (c==aboutGame) {
			Alert alert = new Alert("About", "Crates3D\nBen Ryves 2004\nBased on the game by Badja\nGreenfire Productions", null, AlertType.INFO);
			display.setCurrent(alert);
		} else if (c==returnMain) {
			if (d==canvas) { title.addCommand(resumeGame); }
			display.setCurrent(title);
		} else if (c==selectLevel) {
			prevLevel = levelNumber;
			display.setCurrent(levelSelect);
		} else if (c==chooseNewLevel) {
			lvlGroup.getSelectedIndex();
			levelNumber = lvlGroup.getSelectedIndex();
			if (levelNumber!=prevLevel) {
				GameScreen.unpackLevel(crateLevels[levelNumber]);
			}
			display.setCurrent(canvas);
		} else if (c==toggleSize) {
			useLarge = !useLarge;
			GameScreen.loadImages(useLarge);
			canvas.repaint();		
		} else if (c==resetLevel) {
			GameScreen.unpackLevel(crateLevels[levelNumber]);
			canvas.repaint();
		} else if (c==List.SELECT_COMMAND) {
			Alert alert = new Alert("Well Done", "Well Done!\nYou have completed the level!", null, AlertType.INFO);
			display.setCurrent(alert);
			levelNumber++;
			levelNumber = levelNumber&15;
			GameScreen.unpackLevel(crateLevels[levelNumber]);
			display.setCurrent(canvas);
		} else if (c==helpKeys) {
			Form help = new Form("Help");
			help.append("The aim of the game is to try and get your crate from one end of the course to sit on top of the crate at the other end.\nYou can move around with the up, down, left and right keys. You can only move up and down one crate at a time.\nBy holding the fire key and moving towards another crate you can push crates around the level. Crates will only move if they are on top of something else. Use the a and b keys to rotate the view.\nOn a cellphone, the movement keys are usually 2,4,6 and 8 and the a and b keys are either 1 and 3 or 7 and 9. Fire is typically 5. Just have a look around and see what the keys do!");
			help.addCommand(returnMain);
			help.setCommandListener(this);
			display.setCurrent(help);
		}
	}

	protected void destroyApp(boolean unconditional) { }
   	protected void pauseApp() { }
	protected void startApp() { }
	
}
